<?php

namespace Modules\Tax\Sales;

use Illuminate\Database\Eloquent\Model;

class QuotationType extends Model 
{

    protected $table = 'quotation_types';
    public $timestamps = true;

    public function fiscal_document_type()
    {
        return $this->belongsTo('FiscalDocumentType');
    }

    public function contact_type()
    {
        return $this->belongsTo('ContactType');
    }

    public function document_type_series()
    {
        return $this->morphMany('DocumentTypeSerie', 'serieable');
    }

    public function document_type_issuing_services()
    {
        return $this->morphMany('DocumentTypeIssuingService', 'serviceable');
    }

}